macroScript SESelectChildren
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_SELECT_CHILDREN_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_SELECT_CHILDREN~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.SelectChildren()
	)
)

macroScript SEExpandAll
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_EXPAND_ALL_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_EXPAND_ALL~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.ExpandAll()
	)
)

macroScript SEExpandSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_EXPAND_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_EXPAND_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.ExpandSelected()
	)
)

macroScript SECollapseAll
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_COLLAPSE_ALL_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_COLLAPSE_ALL~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CollapseAll()
	)
)

macroScript SECollapseSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_COLLAPSE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_COLLAPSE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CollapseSelected()
	)
)

macroScript SEInvertFilters
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_INVERT_FILTERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_INVERT_FILTERS~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.InvertDisplay()
	)
)

macroScript SERename
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_RENAME_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_RENAME~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local hasLayers = false
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(		
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					return false;
				)
				hasLayers = true
			)
		)
			
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count == 1 or (count > 1 and not hasLayers) )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance != undefined) do
		(
			if (sceneExplorerInstance.SelectedItemCount() > 1) then
				macros.run "Tools" "RenameObjects"
			else
				sceneExplorerInstance.Rename()		
		)
	)
)

macroScript SEUnlink
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_UNLINK_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_UNLINK~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined or sceneExplorerInstance.IsLayerView()) then return false
		local count = sceneExplorerInstance.SelectedItemCount onlyMaxNodes:true
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.Unlink()
	)
)

macroScript SEDelete
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_DELETE_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_DELETE~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		
		local hasDeletableLayers = false
		local hasNonDeletableLayers = false
		local hasNodes = false
		for item in selectedItems while not hasNonDeletableLayers do 
		(
			if (IsLayer item) then 
			(
				if item.canDelete() then
					hasDeletableLayers = true
				else
					hasNonDeletableLayers = true
			)
			else
				hasNodes = true
		)		
		return (hasNodes or hasDeletableLayers) and not hasNonDeletableLayers
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		local selectedNodes = #()
		local selectedLayers = #()
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				if item.canDelete() then
					append selectedLayers item
			)
			else			
			(
				append selectedNodes item
			)
		)
		if (selectedNodes.Count > 0) then
		(
			delete selectedNodes
		)
		for layer in selectedLayers do 
		(
			LayerManager.deleteLayerByName layer.name
		)
	)
)

macroScript SECreateLayer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_CREATE_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_CREATE~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(		
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					return false;
				)				
			)
		)
		
		return true;
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CreateNewLayer()
	)
)

macroScript SEProperties
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_PROPERTIES_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_PROPERTIES~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		valid = (	(sceneExplorerInstance != undefined) and ( selectedItems.Count > 0) )

		local nodeCount = 0
		local layerCount = 0
			
		for item in selectedItems while valid do 
		(
			if (IsLayer item) then 
			(
				layerCount += 1
			)
			else
			(
			    nodeCount += 1
			)
			if  ((nodeCount > 0) and (layerCount>0)) then
			(
				valid = false
			)
		)		
		return valid;
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local nodeCount = 0
		local layerCount = 0
		local selectedLayers = #()
			
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				append selectedLayers item
				layerCount += 1
			)
			else
			(
			    nodeCount += 1
			)
		)		
		if  ((nodeCount > 0) and (layerCount>0)) then
		(
			return false
		)
		if  (nodeCount > 0) then
		(
			actionMan.executeAction 0 "40022" 
		)
		else
		(	
			layerManager.layerPropDialog selectedLayers
		)
	)
)

macroScript SEUnnest
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_UNNEST_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_UNNEST~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined or not sceneExplorerInstance.IsLayerView()) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		valid = (	(sceneExplorerInstance != undefined) and ( selectedItems.Count > 0) )

		local layerCount = 0
		local parentCount = 0
			
		for item in selectedItems do 
		(
			if (IsLayer item) then 
			(
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					valid = false
				)
				if (item.GetParent() != undefined) then
				(
					parentCount += 1
				)
				layerCount += 1
			)
		)
		
		return (valid and (layerCount > 0) and (parentCount > 0))
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
			
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				if (item.GetParent() != undefined) then
				(
					if not ((SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() ) then
					(			
						item.SetParent undefined
					)
				)				
			)
		)					
	)
)

macroScript SEMakeDefault
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_MAKEDEFAULT_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_MAKEDEFAULT~ --LOC_NOTES: localize this
(	
	fn findExplorerIndex explo =
	(
		local index = -1
		for i = 1 to SceneExplorerManager.GetExplorerCount() do (
			local scnExpl = SceneExplorerManager.getexplorer (SceneExplorerManager.GetExplorerName i)
			if (scnExpl == explo) do
				index = i
		)
		index
	)

	on isVisible do	
	(
		return (SceneExplorerManager.GetActiveExplorer() != undefined)
	)	
	
	on isEnabled do 	
	(		
		return (SceneExplorerManager.GetActiveExplorer() != undefined)
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
					
		local cfgpath = pathConfig.GetDir #plugcfg
		cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
		local fileName = "Default" + sceneExplorerInstance.Name + ".ini"
		local cfgfile = pathConfig.appendPath cfgpath fileName

		local fName = getSaveFileName filename:cfgfile caption:~SEQ_MAKEDEFAULT_TT~ types:~INI_FILES_TYPES~ historyCategory:~SEQ_MAKEDEFAULT~
		if fName != undefined then
		(
			SceneExplorerManager.SaveExplorerConfiguration sceneExplorerInstance.Name fName
		)
	)
)

macroScript SEFindSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_FIND_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_FIND_SELECTED~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.FindSelected()
	)
)

macroScript SEUnfreezeSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"		--LOC_NOTES: do not localize this
	toolTip:~SEQ_UNFREEZE_SELECTED_TT~		--LOC_NOTES: localize this
	ButtonText:~SEQ_UNFREEZE_SELECTED_TT~	--LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false

		local nodesToSelect = #()		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (item.isfrozen) then (
				item.isfrozen = false
				if IsvalidNode item then append nodesToSelect item
			)
		)					
		-- resynch scene selection with explorer selection
		if nodesToSelect.count != 0 do selectmore nodesToSelect 	
	)
)

macroScript SEUnhideSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SEQ_UNHIDE_SELECTED_TT~	--LOC_NOTES: localize this
	ButtonText:~SEQ_UNHIDE_SELECTED_TT~	--LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local nodesToSelect = #()		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (item.ishidden) then (
				item.ishidden = false
				if IsvalidNode item then append nodesToSelect item
			)
		)					
		-- resynch scene selection with explorer selection
		if nodesToSelect.count != 0 do selectmore nodesToSelect 	
	)
)

macroScript SEFreezeSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_FREEZE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_FREEZE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			item.isfrozen = true
		)					
		-- unselect the now frozen objects in the scene
		sceneExplorerInstance.PushSelectionToScene()
	)
)

macroScript SEHideSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_HIDE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_HIDE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			item.ishidden = true
		)
		-- unselect the now hidden objects in the scene
		sceneExplorerInstance.PushSelectionToScene()
	)
)

macroScript SEAddNewLayer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_ADD_NEW_LAYER_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_ADD_NEW_LAYER~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)

	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		local newLayer = LayerManager.newLayer()
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(
				if not item.hasSceneXRefNodesInHierarchy()  then
					item.setparent newLayer
			)
			else
			(		
				newLayer.addnode item 
			)
		)
	)
)

macroScript SEMergeLayers
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_MERGE_LAYERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_MERGE_LAYERS~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)

	fn transferLayerContent fromLayer toLayer = (
		-- first step: transfer the nodes
		local fromLayerNodes = #()
		fromLayer.nodes &fromLayerNodes
		for node in fromLayerNodes do
			toLayer.addnode node

		-- second step: transfer child layers
		local toLayerIntf = getInterface toLayer.layerAsRefTarg "LayerProperties"
		if (toLayerIntf != undefined) then (
			local childLayerCount = fromLayer.getNumChildren()
			for i = childLayerCount to 1 by -1 do
			(
				local item = fromLayer.getChild i
				if (item != undefined) do (
					local fromChildLayerIntf = getInterface item.layerAsRefTarg "LayerProperties"
					if (fromChildLayerIntf != undefined and fromChildLayerIntf != toLayerIntf) do (
						fromChildLayerIntf.setparent toLayerIntf
					)
				)
			)
		)
	)

	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		-- need two layers selected in the active explorer
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local layerCount = 0
		local selectedItems = sceneExplorerInstance.SelectedItems()
		local selCount = selectedItems.Count
		for i = selCount to 1 by -1 do
		(
			local item = selectedItems[i]
			if (IsLayer item) then (
				layerCount += 1
				-- last layer selected (the first we hit here, is the merged into layer
				if (layerCount != 1) then 
				(
					-- can't merge from layer containing scene xref nodes
					if item.HasSceneXRefNodesInHierarchy() then return false
				)
			)
		)
		return (layerCount >= 2)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false

		-- find out the last layer selected
		local mergedIntoLayer = undefined
		local rename = true
		local selectedItems = sceneExplorerInstance.SelectedItems()
		local selCount = selectedItems.Count
		for i = selCount to 1 by -1 while (mergedIntoLayer == undefined) do
		(
			if (IsLayer (selectedItems[i])) then (
				mergedIntoLayer = selectedItems[i]
			)
		)
		if (mergedIntoLayer == undefined) then return false
		-- default layer cannot be renamed
		rename = (SceneExplorerManager.IsDefaultLayer mergedIntoLayer == false) and not mergedIntoLayer.HasSceneXRefNodesInHierarchy()

		-- go through selected layers, transfering content to the mergedIntoLayer
		for item in selectedItems do 
		(
			if (IsLayer item) then (
				if (item != mergedIntoLayer and not item.HasSceneXRefNodesInHierarchy()) then (
					-- if a layer to be merged is current then make the merging layer current
					-- this allows deleting it
					if (item.current) then
						mergedIntoLayer.current = true

					transferLayerContent item mergedIntoLayer
						-- the default layer cannot be deleted so that will leave several layers selected
						-- and we can't predict which one will be put in rename mode.  Skip renaming in that case.
					if (SceneExplorerManager.IsDefaultLayer item) then
						rename = false
					else
						layermanager.deleteLayerByName item.name
				)
			)
			else (
				-- if we have a node selected, we can't predict which explorer node will be affected by the Rename()
				rename = false
			)
		)

		if (rename) then (
			-- wait until layer deletion has finished refreshing the scene explorers 
			-- before using Rename mode
			windows.processPostedMessages()
			sceneExplorerInstance.Rename()
		)
	)
)

macroScript SESceneExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_SCENE_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_SCENE_EXPLORER~		--LOC_NOTES: localize this
 	Icon:#("SceneExplorer", 1)			--LOC_NOTES: do not localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_SCENE_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_SCENE_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_SCENE_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~ and not sceneexplorermanager.IsExplorerInViewport ~SE_SCENE_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_SCENE_EXPLORER_NAME~
	)
)

macroScript SELayerExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_LAYER_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_LAYER_EXPLORER~		--LOC_NOTES: localize this
 	Icon:#("LayerToolbar",5)--LOC_NOTES: do not localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_LAYER_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_LAYER_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_LAYER_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~ and not sceneexplorermanager.IsExplorerInViewport ~SE_LAYER_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_LAYER_EXPLORER_NAME~
	)
)

macroScript SEContainerExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_CONTAINER_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_CONTAINER_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_CONTAINER_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_CONTAINER_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_CONTAINER_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_CONTAINER_EXPLORER_NAME~
	)
)

macroScript SEDynamicsExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_DYNAMICS_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_DYNAMICS_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_DYNAMICS_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_DYNAMICS_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_DYNAMICS_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_DYNAMICS_EXPLORER_NAME~
	)
)

macroScript SELightExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_LIGHT_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_LIGHT_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_LIGHT_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_LIGHT_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_LIGHT_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_LIGHT_EXPLORER_NAME~
	)
)

macroScript SEMissingPluginExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_MISSINGPLUGIN_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_MISSINGPLUGIN_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_MISSINGPLUGIN_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_MISSINGPLUGIN_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_MISSINGPLUGIN_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_MISSINGPLUGIN_EXPLORER_NAME~
	)
)

macroScript SERevitPropertyExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_REVITPROPERTY_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_REVITPROPERTY_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_REVITPROPERTY_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_REVITPROPERTY_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_REVITPROPERTY_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_REVITPROPERTY_EXPLORER_NAME~
	)
)

